<?php
/**
 * Settings page for Download Button for Digital Products plugin
 *
 * @package Download_Button_For_Digital_Products
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Show settings page content
function dbdp_render_settings_page() {
	?>
	<div class="wrap dbdp-settings-page">
		<div class="dbdp-header">
			<h1><span class="dashicons dashicons-download"></span> <?php esc_html_e( 'Download Button for Digital Products', 'download-button-for-digital-products' ); ?></h1>
			<p class="description"><?php esc_html_e( 'Customize the appearance and behavior of the download button for purchased products.', 'download-button-for-digital-products' ); ?></p>
		</div>
		
		<div class="dbdp-settings-container">
			<div class="dbdp-settings-card">
				<form method="post" action="options.php">
					<?php 
					settings_fields( 'dbdp_settings_group' );
					?>
					
					<div class="dbdp-form-section">
						<h2><?php esc_html_e( 'General Settings', 'download-button-for-digital-products' ); ?></h2>
						
						<div class="dbdp-form-field">
							<div class="dbdp-toggle-container">
								<label class="dbdp-toggle">
									<input type="checkbox" name="dbdp_enable_feature" value="1" <?php checked( 1, get_option( 'dbdp_enable_feature', 1 ), true ); ?> />
									<span class="dbdp-toggle-slider"></span>
								</label>
								<span class="dbdp-toggle-label"><?php esc_html_e( 'Enable Feature', 'download-button-for-digital-products' ); ?></span>
							</div>
							<p class="description"><?php esc_html_e( 'Enable/disable the download button functionality.', 'download-button-for-digital-products' ); ?></p>
						</div>
						
						<div class="dbdp-form-field">
							<label for="dbdp_download_button_text"><?php esc_html_e( 'Download Button Text', 'download-button-for-digital-products' ); ?></label>
							<input type="text" id="dbdp_download_button_text" name="dbdp_download_button_text" value="<?php echo esc_attr( get_option( 'dbdp_download_button_text', 'Download Now' ) ); ?>" />
						</div>
					</div>
					
					<div class="dbdp-form-section">
						<h2><?php esc_html_e( 'Button Styling', 'download-button-for-digital-products' ); ?></h2>
						
						<div class="dbdp-form-row">
							<div class="dbdp-form-field">
								<label for="dbdp_download_button_color"><?php esc_html_e( 'Button Color', 'download-button-for-digital-products' ); ?></label>
								<input type="text" id="dbdp_download_button_color" name="dbdp_download_button_color" value="<?php echo esc_attr( get_option( 'dbdp_download_button_color', '#4CAF50' ) ); ?>" class="dbdp-color-field" />
							</div>
							
							<div class="dbdp-form-field">
								<label for="dbdp_download_button_hover_color"><?php esc_html_e( 'Button Hover Color', 'download-button-for-digital-products' ); ?></label>
								<input type="text" id="dbdp_download_button_hover_color" name="dbdp_download_button_hover_color" value="<?php echo esc_attr( get_option( 'dbdp_download_button_hover_color', '#45a049' ) ); ?>" class="dbdp-color-field" />
							</div>
						</div>
						
						<div class="dbdp-form-row">
							<div class="dbdp-form-field">
								<label for="dbdp_download_button_text_color"><?php esc_html_e( 'Text Color', 'download-button-for-digital-products' ); ?></label>
								<input type="text" id="dbdp_download_button_text_color" name="dbdp_download_button_text_color" value="<?php echo esc_attr( get_option( 'dbdp_download_button_text_color', '#fff' ) ); ?>" class="dbdp-color-field" />
							</div>
							
							<div class="dbdp-form-field">
								<label for="dbdp_button_border_radius"><?php esc_html_e( 'Border Radius (px)', 'download-button-for-digital-products' ); ?></label>
								<input type="number" id="dbdp_button_border_radius" name="dbdp_button_border_radius" value="<?php echo esc_attr( get_option( 'dbdp_button_border_radius', '5' ) ); ?>" min="0" max="50" />
							</div>
						</div>
						
						<div class="dbdp-form-field">
							<label for="dbdp_button_padding"><?php esc_html_e( 'Button Padding (px)', 'download-button-for-digital-products' ); ?></label>
							<input type="text" id="dbdp_button_padding" name="dbdp_button_padding" value="<?php echo esc_attr( get_option( 'dbdp_button_padding', '12 24' ) ); ?>" placeholder="12 24" />
							<p class="description"><?php esc_html_e( 'Enter vertical and horizontal padding values separated by space (e.g., "12 24" for 12px vertical, 24px horizontal).', 'download-button-for-digital-products' ); ?></p>
						</div>
					</div>
					
					<div class="dbdp-form-section">
						<h2><?php esc_html_e( 'Button Preview', 'download-button-for-digital-products' ); ?></h2>
						<div class="dbdp-button-preview">
							<button id="dbdp-preview-button" class="dbdp-download-button"><?php echo esc_html( get_option( 'dbdp_download_button_text', 'Download Now' ) ); ?></button>
						</div>
					</div>
					
					<?php submit_button( 'Save Settings', 'primary', 'submit', true ); ?>
				</form>
			</div>
			
			<div class="dbdp-sidebar">
				<div class="dbdp-sidebar-card">
					<h3><?php esc_html_e( 'Plugin Information', 'download-button-for-digital-products' ); ?></h3>
					<p><?php esc_html_e( 'Thank you for using our plugin. If you have any questions or need support, please visit our website.', 'download-button-for-digital-products' ); ?></p>
					<p><a href="https://zenorbd.com" target="_blank" class="button button-secondary"><?php esc_html_e( 'Visit Author Website', 'download-button-for-digital-products' ); ?></a></p>
				</div>
				
				<div class="dbdp-sidebar-card">
					<h3><?php esc_html_e( 'Need Help?', 'download-button-for-digital-products' ); ?></h3>
					<p><?php esc_html_e( 'Contact us through any of these channels:', 'download-button-for-digital-products' ); ?></p>
					<div class="dbdp-social-links">
						<a href="https://www.facebook.com/zenorbd" target="_blank" class="dbdp-social-link">
							<span class="dashicons dashicons-facebook"></span> Facebook
						</a>
						<a href="https://www.instagram.com/zenor_bd" target="_blank" class="dbdp-social-link">
							<span class="dashicons dashicons-instagram"></span> Instagram
						</a>
						<a href="https://wa.me/8801912445151" target="_blank" class="dbdp-social-link">
							<span class="dashicons dashicons-whatsapp"></span> WhatsApp
						</a>
						<a href="https://m.me/zenorbd" target="_blank" class="dbdp-social-link">
							<span class="dashicons dashicons-facebook-alt"></span> Messenger
						</a>
						<a href="tel:01912445151" class="dbdp-social-link">
							<span class="dashicons dashicons-phone"></span> Call Us
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}